/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.util.NoSuchElementException;
import java.util.Random;
import peernet.util.IndexIterator;

public class RandPermutation
implements IndexIterator {
    private int[] buffer = null;
    private int len = 0;
    private int pointer = 0;
    private final Random r;

    public RandPermutation(Random r) {
        this.r = r;
    }

    public void setPermutation(int k) {
        this.reset(k);
        int i = this.len;
        while (i > 1) {
            int j = this.r.nextInt(i);
            int a = this.buffer[j];
            this.buffer[j] = this.buffer[i - 1];
            this.buffer[i - 1] = a;
            --i;
        }
    }

    public int get(int i) {
        if (i >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[i];
    }

    @Override
    public void reset(int k) {
        this.pointer = k;
        if (this.len == k) {
            return;
        }
        if (this.buffer == null || this.buffer.length < k) {
            this.buffer = new int[k];
        }
        this.len = k;
        int i = 0;
        while (i < this.len) {
            this.buffer[i] = i;
            ++i;
        }
    }

    @Override
    public int next() {
        if (this.pointer < 1) {
            throw new NoSuchElementException();
        }
        int j = this.r.nextInt(this.pointer);
        int a = this.buffer[j];
        this.buffer[j] = this.buffer[this.pointer - 1];
        this.buffer[this.pointer - 1] = a;
        return this.buffer[--this.pointer];
    }

    @Override
    public boolean hasNext() {
        return this.pointer > 0;
    }
}

